<?php
/**
 * Elementor Widget
 * @package Panthar
 * @since 1.0.0
 */

namespace Elementor;
class Panthar_Accordion_One extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'panthar-accordion-one-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Accordion', 'panthar-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-editor-list-ul';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['panthar_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('General Settings', 'panthar-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'accordion_style',
            [
                'label' => esc_html__('Accordion Style', 'panthar-core'),
                'type' => Controls_Manager::SELECT,
                'default' => 'without-image',
                'options' => [
                    'without-image' => esc_html__('Without Image', 'panthar-core'),
                    'with-image' => esc_html__('With Image', 'panthar-core'),
                ],
            ]
        );
        $repeater->add_control(
            'title', [
                'label' => esc_html__('Title', 'panthar-core'),
                'type' => Controls_Manager::TEXTAREA,
                'description' => esc_html__('enter title.', 'panthar-core'),
                'default' => esc_html__('1. Is panthar Luxury and comfort?', 'panthar-core')
            ]
        );
        $repeater->add_control(
            'image', [
                'label' => esc_html__('Image', 'panthar-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => false,
                'condition' => ['accordion_style' => 'with-image']
            ]
        );
        $repeater->add_control(
            'accordion-list-item',
            [
                'default' => esc_html__('Specialized bilingual guide', 'panthar-core'),
                'label' => esc_html__('Accordion List', 'panthar-core'),
                'type' => Controls_Manager::TEXTAREA,
                'condition' => ['accordion_style' => 'with-image'],
                'description' => esc_html__('Press Enter For New Item', 'panthar-core')
            ]
        );
        $repeater->add_control(
            'description', [
                'label' => esc_html__('Description', 'panthar-core'),
                'type' => Controls_Manager::TEXTAREA,
                'description' => esc_html__('enter text.', 'panthar-core'),
                'default' => esc_html__('If you’re unsure about what salary is appropriate for a security guard, visit Indeeds Salary Calculator to get a free, personalized pay range based on your location, industry and experience.', 'panthar-core')
            ]
        );
        $this->add_control('accordion_items', [
            'label' => esc_html__('Accordion Item', 'panthar-core'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),

        ]);
        $this->end_controls_section();


        /*  tab styling tabs start */
        $this->start_controls_section(
            'tab_settings_section',
            [
                'label' => esc_html__('Tab Settings', 'panthar-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs(
            'tab_style_tabs'
        );

        $this->start_controls_tab(
            'tab_style_normal_tab',
            [
                'label' => __('Expanded Style', 'panthar-core'),
            ]
        );

        $this->add_control('tab_color', [
            'type' => Controls_Manager::COLOR,
            'label' => esc_html__('Title Color', 'panthar-core'),
            'selectors' => [
                "{{WRAPPER}} .accordion-wrapper .card .card-header a[aria-expanded=true]" => "color: {{VALUE}}",
            ]
        ]);
        $this->add_control('tab_paragraph_color', [
            'type' => Controls_Manager::COLOR,
            'label' => esc_html__('Paragraph Color', 'panthar-core'),
            'selectors' => [
                "{{WRAPPER}} .accordion-wrapper .card .card-body" => "color: {{VALUE}}",
            ]
        ]);
        $this->add_control('tab_icon_color', [
            'type' => Controls_Manager::COLOR,
            'label' => esc_html__('Icon Color', 'panthar-core'),
            'selectors' => [
                "{{WRAPPER}} .accordion-wrapper .card .card-header a:after" => "color: {{VALUE}}",
            ]
        ]);
        $this->add_control('tab_icon_bg_color', [
            'type' => Controls_Manager::COLOR,
            'label' => esc_html__('Icon Background Color', 'panthar-core'),
            'selectors' => [
                "{{WRAPPER}} .accordion-wrapper .card .card-header a:after" => "background-color: {{VALUE}}",
            ]
        ]);
        $this->add_control('tab_background', [
            'type' => Controls_Manager::COLOR,
            'label' => esc_html__('Background', 'panthar-core'),
            'selectors' => [
                "{{WRAPPER}} .accordion-wrapper .card .card-body" => "background-color: {{VALUE}}",
                "{{WRAPPER}} .accordion-wrapper .card .card-header a[aria-expanded=true]" => "background-color: {{VALUE}}",
            ]
        ]);

        $this->end_controls_tab();

        $this->start_controls_tab(
            'button_style_hover_tab',
            [
                'label' => esc_html__('Normal', 'panthar-core'),
            ]
        );

        $this->add_control('tab_hover_color', [
            'type' => Controls_Manager::COLOR,
            'label' => esc_html__('Title Color', 'panthar-core'),
            'selectors' => [
                "{{WRAPPER}} .accordion-wrapper .card .card-header a" => "color: {{VALUE}}",
            ]
        ]);
        $this->add_control('tab_hover_paragraph_color', [
            'type' => Controls_Manager::COLOR,
            'label' => esc_html__('Paragraph Color', 'panthar-core'),
            'selectors' => [
                "{{WRAPPER}} .accordion-wrapper .card .card-body" => "color: {{VALUE}}",
            ]
        ]);
        $this->add_control('tab_hover_icon_color', [
            'type' => Controls_Manager::COLOR,
            'label' => esc_html__('Icon Color', 'panthar-core'),
            'selectors' => [
                "{{WRAPPER}} .accordion-wrapper .card .card-header a[aria-expanded=false]:after" => "color: {{VALUE}}",
            ]
        ]);
        $this->add_control('tab_hover_icon_bg_color', [
            'type' => Controls_Manager::COLOR,
            'label' => esc_html__('Icon Background Color', 'panthar-core'),
            'selectors' => [
                "{{WRAPPER}} .accordion-wrapper .card .card-header a[aria-expanded=false]:after" => "background-color: {{VALUE}}",
            ]
        ]);
        $this->add_control('tab_hover_background', [
            'type' => Controls_Manager::COLOR,
            'label' => esc_html__('Background', 'panthar-core'),
            'selectors' => [
                "{{WRAPPER}} .accordion-wrapper .card .card-body" => "background-color: {{VALUE}}",
                "{{WRAPPER}} .accordion-wrapper .card .card-header a" => "background-color: {{VALUE}}",
            ]
        ]);


        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();
        /*  tab styling tabs end */

        $this->start_controls_section(
            'typography_settings_section',
            [
                'label' => esc_html__('Typography Settings', 'panthar-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Title Typography', 'panthar-core'),
            'name' => 'title_typography',
            'description' => esc_html__('select title typography', 'panthar-core'),
            'selector' => "{{WRAPPER}} .accordion-wrapper .card .card-header a"
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Paragraph Typography', 'panthar-core'),
            'name' => 'paragraph_typography',
            'description' => esc_html__('select Paragraph typography', 'panthar-core'),
            'selector' => "{{WRAPPER}} .accordion-wrapper .card .card-body"
        ]);
        $this->end_controls_section();

    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $accordion_items = $settings['accordion_items'];
        $random_number = rand(999, 999999);
        ?>
        <div class="accordion-wrap">
            <div id="accordion-<?php echo esc_attr($random_number); ?>">
                <?php
                $a = 0;
                $i = 1;
                foreach ($accordion_items as $item):
                    $collapse_class = (0 == $a) ? '' : 'collapsed';
                    $show_class = (0 == $a) ? 'show' : '';
                    $aria_expanded = (0 == $a) ? 'true' : 'false';
                    $a++;
                    $random__item_number = rand(999, 999999);
                    $image_id = $item['image']['id'] ?? '';
                    $image_url = !empty($image_id) ? wp_get_attachment_image_src($image_id, 'full', false)[0] : '';
                    $image_alt = get_post_meta($image_id, '_wp_attachment_image_alt', true);

                    ?>
                    <div class="card single-accordion-inner">
                        <div class="card-header" id="headingOne_<?php echo esc_attr($random__item_number); ?>">
                            <a class="<?php echo esc_attr($collapse_class); ?>" data-toggle="collapse" role="button"
                               data-target="#collapseOne_<?php echo esc_attr($random__item_number); ?>"
                               aria-expanded="<?php echo esc_attr($aria_expanded); ?>"
                               aria-controls="collapseOne_<?php echo esc_attr($random__item_number); ?>">
                                <span><?php echo esc_html($i); ?>.</span> 
                                <?php echo esc_html($item['title']); ?>
                                
                            </a>
                        </div>
                        <div id="collapseOne_<?php echo esc_attr($random__item_number); ?>"
                             class="collapse <?php echo esc_attr($show_class); ?>"
                             data-parent="#accordion-<?php echo esc_attr($random_number); ?>">
                            <?php
                            if ($item['accordion_style'] === 'without-image'): ?>

                                <div class="card-body">
                                    <?php echo esc_html($item['description']); ?>
                                </div>
                            <?php endif;
                            if ($item['accordion_style'] === 'with-image'):
                                ?>
                                <div class="card-body style-01">
                                    <img src="<?php echo esc_url($image_url); ?>"
                                         alt="<?php echo esc_attr($image_alt); ?>">
                                    <div class="card-body-inner">
                                        <?php echo esc_html($item['description']);
                                        $all_list_items = strlen($item['accordion-list-item']) > 1 ? explode("\n", $item['accordion-list-item']) : [];
                                        if (!empty($all_list_items)):
                                            ?>
                                            <ul>
                                                <?php
                                                foreach ($all_list_items as $nested_item) {
                                                    printf('<li><i class="far fa-check-circle"></i> %s</li>', $nested_item);
                                                }
                                                ?>
                                            </ul>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>

                <?php $i++; endforeach; ?>
            </div>
        </div>
        <?php
    }
}

Plugin::instance()->widgets_manager->register(new Panthar_Accordion_One());