<?php
/**
 * Elementor Widget
 * @package Panthar
 * @since 1.0.0
 */

namespace Elementor;
class Panthar_Core_Value_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'panthar-core-value-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Core Value', 'panthar-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-slider-push';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['panthar_widgets'];
    }

    public function get_keywords()
    {
        return ['Core Value', 'Sponsor', 'Clint', "ThemeIM", 'Panthar'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('General Settings', 'panthar-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'cliping_path',
            [
                'label' => esc_html__('Cliping on/off', 'panthar-core'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes'
            ]
        );
        $this->add_control(
            'border_off',
            [
                'label' => esc_html__('Border on/off', 'panthar-core'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no'
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'core_value', [
                'label' => esc_html__('Core Value', 'panthar-core'),
                'type' => Controls_Manager::TEXT,
                'description' => esc_html__('Please add Your Core Value', 'panthar-core'),
                'default' => 'Compassion'
            ]
        );
        $this->add_control('screenshort_items', [
            'label' => esc_html__('Brand Slider Item', 'panthar-core'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [
                [
                    'image' => array(
                        'url' => Utils::get_placeholder_image_src()
                    )
                ]
            ],

        ]);
        $this->end_controls_section();

        $this->start_controls_section(
            'slider_settings_section',
            [
                'label' => esc_html__('Slider Settings', 'panthar-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'items',
            [
                'label' => esc_html__('Items', 'panthar-core'),
                'type' => Controls_Manager::TEXT,
                'description' => esc_html__('you can set how many item show in slider', 'panthar-core'),
                'default' => '4'
            ]
        );
        $this->add_control(
            'margin',
            [
                'label' => esc_html__('Margin', 'panthar-core'),
                'description' => esc_html__('you can set margin for slider', 'panthar-core'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 5,
                    ]
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 30,
                ],
                'size_units' => ['px'],
                'condition' => array(
                    'autoplay' => 'yes'
                )
            ]
        );
        $this->add_control(
            'loop',
            [
                'label' => esc_html__('Loop', 'panthar-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('you can set yes/no to enable/disable', 'panthar-core')
            ]
        );
        $this->add_control(
            'autoplay',
            [
                'label' => esc_html__('Autoplay', 'panthar-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('you can set yes/no to enable/disable', 'panthar-core'),

            ]
        );
        $this->add_control(
            'autoplaytimeout',
            [
                'label' => esc_html__('Autoplay Timeout', 'panthar-core'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 10000,
                        'step' => 2,
                    ]
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 5000,
                ],
                'size_units' => ['px'],
                'condition' => array(
                    'autoplay' => 'yes'
                )
            ]

        );
        $this->end_controls_section();

        //STYLE FIELD HERE
        $this->start_controls_section(
            'core_value_style',
            [
                'label' => esc_html__('Styling Settings', 'panthar-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control('bg_color', [
            'label' => esc_html__('BG Color', 'panthar-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .single-core-value" => "background: {{VALUE}}"
            ]
        ]);
        $this->add_control('animate_border_color', [
            'label' => esc_html__('Animate Border Color', 'panthar-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .single-core-value .style-animate-dot-wrap:before " => "border-color: {{VALUE}}",
                "{{WRAPPER}} .single-core-value .style-animate-dot-wrap:after " => "border-color: {{VALUE}}",
            ]
        ]);
        $this->add_control('value_text_color', [
            'label' => esc_html__('Color', 'panthar-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .single-core-value p" => "color: {{VALUE}}",
                "{{WRAPPER}} .single-core-value p" => "color: {{VALUE}}",
            ]
        ]);
        $this->end_controls_section();

    }

    /**
     * Render Elementor widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $carousel_add_class = '';
        if($settings['cliping_path'] == 'yes'){
            $carousel_add_class = 'core-value-style-cliping';
        }
        $carousel_remove_border = '';
        if($settings['border_off'] == 'yes'){
            $carousel_remove_border = 'core-value-remove-border';
        }

        $all_screenshort_item = $settings['screenshort_items'];
        $rand_numb = rand(333, 999999999);

        //slider settings
        $slider_settings = [
            "loop" => esc_attr($settings['loop']),
            "margin" => esc_attr($settings['margin']['size'] ?? 0),
            "items" => esc_attr($settings['items'] ?? 1),
            "autoplay" => esc_attr($settings['autoplay']),
            "autoplaytimeout" => esc_attr($settings['autoplaytimeout']['size'] ?? 0),
        ]
        //slick-carousel
        ?>
        <div class="core-value-carousel-wrapper">
            <div class="core-value-carousel <?php echo $carousel_add_class; ?> <?php echo $carousel_remove_border; ?>"
                 id="core-value-one-carousel-<?php echo esc_attr($rand_numb); ?>"
                 data-settings='<?php echo json_encode($slider_settings) ?>'
            >
                <?php
                foreach ($all_screenshort_item as $item): ?>
                    <div class="single-core-value text-center">
                        <span class="style-animate-dot-wrap">
                            <span class="style-animate-dot"></span>
                        </span>
                        <p class="d-inline-block"><?php echo $item['core_value']; ?></p>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
        <?php
    }
}

Plugin::instance()->widgets_manager->register(new Panthar_Core_Value_Widget());