<?php
/**
 * Elementor Widget
 * @package Panthar
 * @since 1.0.0
 */

namespace Elementor;
class Panthar_Service_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'panthar-service-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Service', 'panthar-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-post-slider';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['panthar_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('General Settings', 'panthar-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control('service_grid_status', [
            'label' => esc_html__('Service Grid Status', 'panthar-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'grid' => esc_html__('Grid Style', 'panthar-core'),
                'grid-2' => esc_html__('Grid Style 02', 'panthar-core'),
                'grid-3' => esc_html__('Grid Style 03', 'panthar-core'),
            ),
            'default' => 'grid',
            'description' => esc_html__('Select Service Status', 'panthar-core')
        ]);
        $this->add_control(
            'grid_gutter_status',
            [
                'label' => esc_html__('Gutter Show/Hide', 'panthar-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('Please click and choose no gutter', 'panthar-core'),
            ]
        );
        $this->add_control('column_select', [
            'label' => esc_html__('Column Select', 'panthar-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'col-lg-3' => esc_html__('col-lg-3', 'panthar-core'),
                'col-lg-4' => esc_html__('col-lg-4', 'panthar-core'),
                'col-lg-6' => esc_html__('col-lg-6', 'panthar-core'),
                'col-lg-12' => esc_html__('col-lg-12', 'panthar-core'),
            ),
            'default' => 'col-lg-4',
        ]);
        $this->add_control(
            'offset',
            [
                'label' => esc_html__('Post Offset', 'panthar-core'),
                'type' => Controls_Manager::TEXT,
            ]
        );
        $this->add_control(
            'pagination',
            [
                'label' => esc_html__('Pagination', 'panthar-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('you can set yes to show pagination.', 'panthar-core'),
                'default' => 'yes'
            ]
        );
        $this->add_control(
            'pagination_alignment',
            [
                'label' => esc_html__('Pagination Alignment', 'panthar-core'),
                'type' => Controls_Manager::SELECT,
                'options' => array(
                    'left' => esc_html__('Left Align', 'panthar-core'),
                    'center' => esc_html__('Center Align', 'panthar-core'),
                    'right' => esc_html__('Right Align', 'panthar-core'),
                ),
                'description' => esc_html__('you can set pagination alignment.', 'panthar-core'),
                'default' => 'left',
                'condition' => array('pagination' => 'yes')
            ]
        );
        $this->add_control(
            'animate_image_status',
            [
                'label' => esc_html__('Animate Image Show/Hide', 'panthar-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('show/hide Animate Image', 'panthar-core'),
            ]
        );
        $this->add_control(
            'animate_icon',
            [
                'label' => esc_html__('Animation Icon', 'panthar-core'),
                'type' => Controls_Manager::ICONS,
                'description' => esc_html__('select Icon.', 'panthar-core'),
                'default' => [
                    'value' => 'fas fa-plus',
                    'library' => 'solid',
                ],
                'condition' => ['animate_image_status' => 'yes']
            ]
        );

        $this->add_control('total', [
            'label' => esc_html__('Total Posts', 'panthar-core'),
            'type' => Controls_Manager::TEXT,
            'default' => '-1',
            'description' => esc_html__('enter how many service you want in masonry , enter -1 for unlimited service.')
        ]);
        $this->add_control('category', [
            'label' => esc_html__('Category', 'panthar-core'),
            'type' => Controls_Manager::SELECT2,
            'multiple' => true,
            'options' => Panthar()->get_terms_names('service-cat', 'id'),
            'description' => esc_html__('select category as you want, leave it blank for all category', 'panthar-core'),
        ]);
        $this->add_control('order', [
            'label' => esc_html__('Order', 'panthar-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'ASC' => esc_html__('Ascending', 'panthar-core'),
                'DESC' => esc_html__('Descending', 'panthar-core'),
            ),
            'default' => 'ASC',
            'description' => esc_html__('select order', 'panthar-core')
        ]);
        $this->add_control('orderby', [
            'label' => esc_html__('OrderBy', 'panthar-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'ID' => esc_html__('ID', 'panthar-core'),
                'title' => esc_html__('Title', 'panthar-core'),
                'date' => esc_html__('Date', 'panthar-core'),
                'rand' => esc_html__('Random', 'panthar-core'),
                'comment_count' => esc_html__('Most Comments', 'panthar-core'),
            ),
            'default' => 'ID',
            'description' => esc_html__('select order', 'panthar-core')
        ]);
        $this->add_control('excerpt_length', [
            'label' => esc_html__('Excerpt Length', 'panthar-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                25 => esc_html__('Short', 'panthar-core'),
                55 => esc_html__('Regular', 'panthar-core'),
                100 => esc_html__('Long', 'panthar-core'),
            ),
            'default' => 25,
            'description' => esc_html__('select excerpt length', 'panthar-core')
        ]);
        $this->end_controls_section();

        $this->start_controls_section(
            'styling_settings_section',
            [
                'label' => esc_html__('Styling Settings', 'panthar-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs(
            'title_style_tabs'
        );

        $this->start_controls_tab(
            'title_style_normal_tab',
            [
                'label' => esc_html__('Normal', 'panthar-core'),
            ]
        );
        $this->add_control('icon_color', [
            'label' => esc_html__('Icon Color', 'panthar-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .service-single-item .icon" => "color: {{VALUE}}"
            ]
        ]);
        $this->add_control('content_bg_color', [
            'label' => esc_html__('Background Color', 'panthar-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .service-single-item .content-wrap" => "background-color: {{VALUE}}"
            ]
        ]);
        $this->add_control('title_color', [
            'label' => esc_html__('Title Color', 'panthar-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .service-single-item .content .title" => "color: {{VALUE}}"
            ]
        ]);
        $this->add_control('paragraph_typography', [
            'label' => esc_html__('Paragraph Color', 'panthar-core'),
            'description' => esc_html__('select Paragraph Color', 'panthar-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .service-single-item .content p" => "color: {{VALUE}}"
            ]
        ]);

        $this->end_controls_tab();

        $this->start_controls_tab(
            'title_style_hover_tab',
            [
                'label' => esc_html__('Hover', 'panthar-core'),
            ]
        );

        $this->add_control('icon_hover_color', [
            'label' => esc_html__('Icon Hover Color', 'panthar-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .service-single-item:hover .icon" => "color: {{VALUE}}"
            ]
        ]);
        $this->add_control('content_hover_bg_color', [
            'label' => esc_html__('Background Color', 'panthar-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .service-single-item .content-wrap:hover" => "background-color: {{VALUE}}"
            ]
        ]);
        $this->add_control('title_hover_color', [
            'label' => esc_html__('Title Hover Color', 'panthar-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .service-single-item:hover .content .title" => "color: {{VALUE}}"
            ]
        ]);
        $this->add_control('paragraph_hover_typography', [
            'label' => esc_html__('Paragraph Hover Color', 'panthar-core'),
            'description' => esc_html__('select Paragraph Color', 'panthar-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .service-single-item:hover .content p" => "color: {{VALUE}}"
            ]
        ]);

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();


        $this->start_controls_section(
            'typography_settings_section',
            [
                'label' => esc_html__('Typography Settings', 'panthar-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Title Typography', 'panthar-core'),
            'name' => 'title_typography',
            'description' => esc_html__('select title typography', 'panthar-core'),
            'selector' => "{{WRAPPER}} .service-single-item .content .title"
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Paragraph Typography', 'panthar-core'),
            'name' => 'paragraph_typography',
            'description' => esc_html__('select Paragraph typography', 'panthar-core'),
            'selector' => "{{WRAPPER}} .service-single-item .content p"
        ]);
        $this->end_controls_section();

    }

    /**
     * Render Elementor widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $rand_numb = rand(333, 999999999);
        //query settings
        $total_posts = $settings['total'];
        $category = $settings['category'];
        $order = $settings['order'];
        $orderby = $settings['orderby'];
        $offset = $settings['offset'];
        $no_gutter = '';
        if($settings['grid_gutter_status'] == 'yes') {
            $no_gutter = ' no-gutters';
        }
        //slider settings

        //other settings
        $pagination = $settings['pagination'] ? false : true;
        $pagination_alignment = $settings['pagination_alignment'];

        //setup query
        $args = array(
            'post_type' => 'service',
            'posts_per_page' => $total_posts,
            'order' => $order,
            'orderby' => $orderby,
            'offset'  => $offset,
            'post_status' => 'publish'
        );

        if (!empty($category)) {
            $args['tax_query'] = array(
                array(
                    'taxonomy' => 'service-cat',
                    'field' => 'term_id',
                    'terms' => $category
                )
            );
        }

        $post_data = new \WP_Query($args); 
        if($settings['service_grid_status'] == 'grid'): ?>
            <div class="row<?php echo $no_gutter; ?>">
                <?php while ($post_data->have_posts()):$post_data->the_post(); ?>
                    <div class="<?php echo $settings['column_select']; ?> col-md-6">
                        <div class="service-single-item-list">
                            <?php //image var here
                                $post_id = get_the_ID();
                                $img_id = get_post_thumbnail_id($post_id) ? get_post_thumbnail_id($post_id) : false;
                                $img_url_val = $img_id ? wp_get_attachment_image_src($img_id, 'panthar_classic_service', false) : '';
                                $img_url = is_array($img_url_val) && !empty($img_url_val) ? $img_url_val[0] : '';
                                $img_alt = get_post_meta($img_id, '_wp_attachment_image_alt', true);
                            ?>
                            <div class="service-single-item">
                                <div class="thumb">
                                    <img src="<?php echo esc_url($img_url)?>" alt="<?php echo $img_alt?>">
                                </div>
                                <div class="details">
                                    <h4 class="title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?> </a></h4>
                                    <a class="read-btn" href="<?php the_permalink(); ?>"><i class="fa fa-arrow-right"></i></a>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php
                endwhile;
                wp_reset_query();
                ?>
                <div class="col-lg-12">
                    <div class="blog-pagination text-<?php echo esc_attr($pagination_alignment) ?> margin-top-20">
                        <?php
                        if (!$pagination) {
                            Panthar()->post_pagination($post_data);
                        }
                        ?>
                    </div>
                </div>
            </div>
        <?php elseif($settings['service_grid_status'] == 'grid-2'): ?>
            <div class="row<?php echo $no_gutter; ?>">
                <?php while ($post_data->have_posts()):$post_data->the_post(); ?>
                    <div class="<?php echo $settings['column_select']; ?> col-md-6">
                        <div class="service-single-item-list">
                            <?php //image var here
                                $post_id = get_the_ID();
                                $img_id = get_post_thumbnail_id($post_id) ? get_post_thumbnail_id($post_id) : false;
                                $img_url_val = $img_id ? wp_get_attachment_image_src($img_id, 'panthar_service_2', false) : '';
                                $img_url = is_array($img_url_val) && !empty($img_url_val) ? $img_url_val[0] : '';
                                $img_alt = get_post_meta($img_id, '_wp_attachment_image_alt', true);
                            ?>
                            <div class="service-single-item-2">
                                <div class="thumb">
                                    <img src="<?php echo esc_url($img_url)?>" alt="<?php echo $img_alt?>">
                                    <div class="animate-icon">
                                        <?php
                                        Icons_Manager::render_icon($settings['animate_icon'], ['aria-hidden' => 'true']);
                                        ?>
                                    </div>
                                </div>
                                <div class="details">
                                    <h4 class="title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?> </a></h4>
                                    <a class="read-btn" href="<?php the_permalink(); ?>"><i class="fa fa-arrow-right"></i></a>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php
                endwhile;
                wp_reset_query();
                ?>
            </div>
            <?php elseif($settings['service_grid_status'] == 'grid-3'): ?>
            <div class="row<?php echo $no_gutter; ?>">
                <?php while ($post_data->have_posts()):$post_data->the_post(); ?>
                    <div class="<?php echo $settings['column_select']; ?> col-md-12">
                        <div class="service-single-item-list">
                            <?php //image var here
                                $post_id = get_the_ID();
                                $img_id = get_post_thumbnail_id($post_id) ? get_post_thumbnail_id($post_id) : false;
                                $img_url_val = $img_id ? wp_get_attachment_image_src($img_id, 'panthar_service_2', false) : '';
                                $img_url = is_array($img_url_val) && !empty($img_url_val) ? $img_url_val[0] : '';
                                $img_alt = get_post_meta($img_id, '_wp_attachment_image_alt', true);
                            ?>
                            <div class="service-single-item-three">
                                <div class="thumb">
                                    <img class="w-100" src="<?php echo esc_url($img_url)?>" alt="<?php echo $img_alt?>">
                                    <div class="animate-icon">
                                        <?php
                                        Icons_Manager::render_icon($settings['animate_icon'], ['aria-hidden' => 'true']);
                                        ?>
                                    </div>
                                </div>
                                <div class="details">
                                    <div class="details-wrap">
                                        <div class="details-inner">
                                            <div class="icon">
                                                <i class="fa fa-camera"></i>
                                            </div>
                                            <h4 class="title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?> </a></h4>
                                            <p><?php print wp_trim_words( get_the_content(), 15, null ); ?></p>
                                            <div class="btn-wrap">
                                                <a class="btn btn-border-green" href="<?php the_permalink(); ?>"><?php echo esc_html__('Service Details', 'panthar-core') ?></a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php
                endwhile;
                wp_reset_query();
                ?>
            </div>
        <?php endif;
    }
}

Plugin::instance()->widgets_manager->register(new Panthar_Service_Widget());