<?php
/**
 * The template for displaying 404 Error page
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package Panthar
 */

get_header();
$get_404_options_value = Panthar_Group_Fields_Value::get_404_options_value();
$error_bg_switch = cs_get_option('error_bg_switch');
$error_bg = cs_get_option('error_bg');
?>

    <div id="primary" class="content-area padding-top-110 padding-bottom-110">
        <main id="main" class="site-main">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-lg-7">
                        <div class="error-404 not-found">
                            <?php if (!empty($error_bg_switch)) { ?>
                                <div class="thumb">
                                    <img src="<?php echo esc_url($error_bg['url']) ?>"
                                        alt="<?php echo esc_attr($error_bg['alt']) ?>">
                                </div>
                            <?php } else { ?>
                                <h2 class="title"><?php echo esc_html($get_404_options_value['title']); ?></h2>
                            <?php } ?>
                            <h2 class="sub-title"><?php echo esc_html($get_404_options_value['subtitle']); ?></h2>
                            <p class="paragraph"><?php echo esc_html($get_404_options_value['paragraph']); ?></p>
                            <div class="btn-wrap desktop-center margin-top-35">
                                <a class="btn btn-border-base" href="<?php echo esc_url(home_url('/')); ?>">
                                    <span class="top_left"></span>
                                    <span class="top_right"></span>
                                    <span><?php echo esc_html($get_404_options_value['btn_text']); ?></span>
                                    <span class="bottom_left"></span>
                                    <span class="bottom_right"></span>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </main><!-- #main -->
    </div><!-- #primary -->

<?php
get_footer();
