<?php
/**
 * Header Style 03
 * @package panthar
 * @since 1.0.0
 */

?>
<div class="header-style-04">
    <?php
    $header_four_right_bar_shortcode = cs_get_option('header_four_right_bar_shortcode');


    ?>
    <div class="body-overlay"></div>
    <!-- start navbar -->
    <nav class="navbar navbar-area navbar-expand-lg navigation-style-02 navbar-default">
        <div class="container custom-container">
            <div class="responsive-mobile-menu">
                <div class="logo-wrapper default-logo">
                    <?php
                    $header_four_logo = cs_get_option('header_four_logo');
                    if (has_custom_logo() && empty($header_four_logo['id'])) {
                        the_custom_logo();
                    } elseif (!empty($header_four_logo['id'])) {
                        printf('<a class="site-logo" href="%1$s"><img src="%2$s" alt="%3$s"/></a>', esc_url(get_home_url()), $header_four_logo['url'], $header_four_logo['alt']);
                    } else {
                        printf('<a class="site-title" href="%1$s">%2$s</a>', esc_url(get_home_url()), esc_html(get_bloginfo('title')));
                    }
                    ?>
                </div>
                <div class="logo-wrapper logo-sticky">
                    <?php
                    $header_four_logo_sticky = cs_get_option('header_four_logo_sticky');
                    if (has_custom_logo() && empty($header_four_logo_sticky['id'])) {
                        the_custom_logo();
                    } elseif (!empty($header_four_logo_sticky['id'])) {
                        printf('<a class="site-logo" href="%1$s"><img src="%2$s" alt="%3$s"/></a>', esc_url(get_home_url()), $header_four_logo_sticky['url'], $header_four_logo_sticky['alt']);
                    } else {
                        printf('<a class="site-title" href="%1$s">%2$s</a>', esc_url(get_home_url()), esc_html(get_bloginfo('title')));
                    }
                    ?>
                </div>
                <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#panthar_main_menu"
                        aria-expanded="false" aria-label="Toggle navigation">
                    <span class="navbar-toggler-icon"></span>
                </button>
            </div>
            <?php
            wp_nav_menu(array(
                'theme_location' => 'main-menu',
                'menu_class' => 'navbar-nav w-100',
                'container' => 'div',
                'container_class' => 'collapse navbar-collapse',
                'container_id' => 'panthar_main_menu'
            ));
            ?>
            <div class="nav-right-content">
                <?php if ( class_exists( 'WooCommerce' ) ) { ?>
                    <div class="menu-cart align-self-center">
                        <a href="<?php echo wc_get_cart_url(); ?>" title="<?php _e( 'View your shopping cart', 'panthar' ); ?>">
                            <svg xmlns="http://www.w3.org/2000/svg" width="17.499" height="17.5" viewBox="0 0 17.499 17.5">
                                <g id="cart-svgrepo-com_1_" data-name="cart-svgrepo-com (1)" transform="translate(-2.5 -3.5)">
                                <path id="Path_14082p" data-name="Path 14082" d="M2.5,4.25a.75.75,0,0,1,.75-.75h.558A2.1,2.1,0,0,1,5.653,4.733,6.555,6.555,0,0,1,6.15,6q.05,0,.1,0h12.5a1.25,1.25,0,0,1,1.2,1.593L18.122,14a2.75,2.75,0,0,1-2.645,2H9.53a2.75,2.75,0,0,1-2.652-2.022L6.117,11.2,4.859,6.956l0-.007a7.29,7.29,0,0,0-.519-1.495C4.127,5.069,3.959,5,3.808,5H3.25A.75.75,0,0,1,2.5,4.25Z" fill="#fff"/>
                                <path id="Path_14083p" data-name="Path 14083" d="M9,21a2,2,0,1,0-2-2A2,2,0,0,0,9,21Z" fill="#fff"/>
                                <path id="Path_14084p" data-name="Path 14084" d="M16,21a2,2,0,1,0-2-2A2,2,0,0,0,16,21Z" fill="#fff"/>
                            </g>
                            </svg>
                            <span class="cart-count"><?php echo sprintf ( _n( '%d', '%d', WC()->cart->get_cart_contents_count(), 'panthar'  ), WC()->cart->get_cart_contents_count() ); ?> </span>
                        </a>
                    </div>
                <?php } ?>
                <div class="nav-right-content-info">
                    <?php echo do_shortcode($header_four_right_bar_shortcode); ?>
                </div>
            </div>
        </div>
    </nav>
</div>